/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "SurfaceSetInputFocusCommand.h"
#include "Surface.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"
#include "RendererList.h"
#include "InputManager.h"

ExecutionResult SurfaceSetInputFocusCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());

    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_idtoSet);

    if (surface)
    {
        SeatList surfAccpSeats = surface->getAcceptedSeats();
        SeatList::iterator seat_it;
        RendererList* rList;
        RendererListConstIterator it;

        result = ExecutionSuccess;
        rList = executor->getRendererList();
        for (seat_it = surfAccpSeats.begin();
                (seat_it != surfAccpSeats.end()) && (result == ExecutionSuccess); seat_it++)
        {
            for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
            {
                InputManager* pInputManager = (*it)->getInputManager((char*)(*seat_it)->c_str());
                if (NULL != pInputManager)
                {
                    result = pInputManager->setInputFocusOn(m_idtoSet, m_bitmask, m_is_set) ? ExecutionSuccess : ExecutionFailed;
                }
                else
                {
                    std::string seatName((*seat_it)->c_str());
                    result = ExecutionFailed;
                    LOG_ERROR("GetInputDeviceCapabilitiesCommand", "obtained NULL input manager for seat :" << seatName);
                }
            }
        }
    }

    return result;
}

const std::string SurfaceSetInputFocusCommand::getString()
{
    std::stringstream description;
    description << "SurfaceSetInputFocusCommand("
                << "idtoSet=" << m_idtoSet << "(0x" << std::hex << m_idtoSet << ")" << std::dec
                << ", bitmask=" << m_bitmask
                << ", is_set=" << m_is_set
                << ")";
    return description.str();
}
